#! /bin/sh
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
SCRIPT=/usr/sbin/emir-ctrl
NAME=emir
DESC=emir

test -x $SCRIPT || exit 0

# Include emir defaults if available
if [ -f /etc/default/emir ] ; then
	. /etc/default/emir
fi

set -e

case "$1" in
  start)
  	$SCRIPT start
	;;
  stop)
  	$SCRIPT stop
	;;
  restart|force-reload)
  	$SCRIPT restart
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
